// Copyright 2007. Adobe Systems Incorporated. All Rights Reserved.
package fl.events {
	/**
	 * The SliderEventClickTarget class defines constants for the values of the <code>clickTarget</code>
	 * property of the SliderEvent class.
     *
     * @see SliderEvent
     *
     * @includeExample examples/SliderEventClickTargetExample.as -noswf
     *
     * @langversion 3.0
     * @playerversion Flash 9.0.28.0
	 *  
	 *  @playerversion AIR 1.0

	 *  @productversion Flash CS3
	 */
	public class SliderEventClickTarget {

		/**
         * The Slider thumb was clicked.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const THUMB:String = 'thumb';

		/**
         * The Slider track was clicked.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const TRACK:String = 'track';

	}
}